VERSION 5.00
Begin {C62A69F0-16DC-11CE-9E98-00AA00574A4F} frmAttendance 
   Caption         =   "EMPLOYEES ATTENDANCE FORM"
   ClientHeight    =   7920
   ClientLeft      =   120
   ClientTop       =   465
   ClientWidth     =   7755
   OleObjectBlob   =   "frmAttendance.frx":0000
   StartUpPosition =   1  'CenterOwner
End
Attribute VB_Name = "frmAttendance"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit
Const EMP_SHEET = "EMPLOYEES"
Const ATT_SHEET = "ATTENDANCE"


Private Sub CalIcon_Click()
Call Calendar.SelectedDate(Me.dtAttendanceDate)
End Sub


Private Sub UserForm_Initialize()

Dim ws As Worksheet
Dim lastRow As Long
Dim i As Long

Set ws = Sheets(EMP_SHEET)

'Default date = today
dtAttendanceDate.Value = Date

'Clear list
lstEmployees.Clear

'Set to show 2 columns internally
lstEmployees.ColumnCount = 3
lstEmployees.ColumnWidths = "80 pt;150 pt;0 pt"

lastRow = ws.Cells(ws.Rows.Count, "A").End(xlUp).Row

For i = 2 To lastRow
    If LCase(ws.Cells(i, 7).Value) = "active" Then
        lstEmployees.AddItem ws.Cells(i, 1).Value        'EmpID
        lstEmployees.List(lstEmployees.ListCount - 1, 1) = ws.Cells(i, 2).Value  'FullName
    End If
Next i

'Fill status options
cboStatus.Clear
cboStatus.AddItem "P"
cboStatus.AddItem "A"
cboStatus.AddItem "L"

'Clear hidden status column
For i = 0 To lstEmployees.ListCount - 1
    lstEmployees.List(i, 2) = ""
Next i


End Sub


Private Sub cmdMarkSelected_Click()

If lstEmployees.ListIndex = -1 Then
    MsgBox "Please select an employee", vbExclamation
    Exit Sub
End If

If cboStatus.Value = "" Then
    MsgBox "Please select a status (P/A/L)", vbExclamation
    Exit Sub
End If

'STORE STATUS IN HIDDEN 3rd COLUMN
lstEmployees.List(lstEmployees.ListIndex, 2) = cboStatus.Value

MsgBox "Status assigned for selected employee. Remember to SAVE.", vbInformation

End Sub


Private Sub cmdMarkAllPresent_Click()

Dim i As Long

If lstEmployees.ListCount = 0 Then
    MsgBox "No employees loaded!", vbExclamation
    Exit Sub
End If

For i = 0 To lstEmployees.ListCount - 1
    lstEmployees.List(i, 2) = "P"
Next i

MsgBox "All employees marked PRESENT. Remember to SAVE.", vbInformation

End Sub



Private Sub cmdSaveAll_Click()

Dim ws As Worksheet
Dim nextRow As Long
Dim i As Long
Dim attDate As Date
Dim empID As String
Dim f As Range
Dim foundRow As Long
Dim firstAddress As String
Dim empStatus As String

If lstEmployees.ListCount = 0 Then
    MsgBox "No employees to save!", vbExclamation
    Exit Sub
End If

If Not IsDate(dtAttendanceDate.Value) Then
    MsgBox "Invalid Date", vbCritical
    Exit Sub
End If

attDate = dtAttendanceDate.Value
Set ws = Sheets(ATT_SHEET)

For i = 0 To lstEmployees.ListCount - 1
    
    'READ STATUS FROM HIDDEN COLUMN
    empStatus = Trim("" & lstEmployees.List(i, 2))
    
    '==============================
    ' SKIP EMPLOYEES WITH NO STATUS
    '==============================
    If empStatus = "" Then GoTo ContinueLoop
    
    empID = lstEmployees.List(i, 0)
    foundRow = 0
    
    '--------------------------------
    ' FIND SAME DATE IN ATTENDANCE
    '--------------------------------
    Set f = ws.Range("A:A").Find(attDate, LookIn:=xlValues, LookAt:=xlWhole)
    
    If Not f Is Nothing Then
        firstAddress = f.Address
        
        Do
            If ws.Cells(f.Row, 2).Value = empID Then
                foundRow = f.Row
                Exit Do
            End If
            
            Set f = ws.Range("A:A").FindNext(f)
            
        Loop While Not f Is Nothing And f.Address <> firstAddress
    End If
    
    
    '====================================
    ' IF RECORD EXISTS ? UPDATE
    '====================================
    If foundRow <> 0 Then
    
        ws.Cells(foundRow, 3).Value = empStatus
        ws.Cells(foundRow, 4).Value = txtCheckIn.Value
        ws.Cells(foundRow, 5).Value = txtCheckOut.Value
        ws.Cells(foundRow, 6).Value = txtComments.Value
    
    '====================================
    ' ELSE ADD NEW ROW
    '====================================
    Else
    
        nextRow = ws.Cells(ws.Rows.Count, "A").End(xlUp).Row + 1
        
        ws.Cells(nextRow, 1).Value = attDate
        ws.Cells(nextRow, 2).Value = empID
        ws.Cells(nextRow, 3).Value = empStatus
        ws.Cells(nextRow, 4).Value = txtCheckIn.Value
        ws.Cells(nextRow, 5).Value = txtCheckOut.Value
        ws.Cells(nextRow, 6).Value = txtComments.Value
        
    End If

ContinueLoop:
Next i

MsgBox "Attendance Saved / Updated Successfully!", vbInformation

End Sub






Private Sub cmdClose_Click()
    Unload Me
End Sub

